/**
 *
 *
 *  iRoom framework V2.0 <https://iroom.re>
 *
 *  By KRATZ Geoffrey AKA Jul6art AKA VanIllaSkype
 *  for VsWeb <https://vsweb.be>
 *
 *  https://vsweb.be
 *  admin@vsweb.be
 *
 *  Special thanks to Brynnlow
 *  for his contribution
 *
 *  It is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License, either version 2
 *  of the License, or any later version.
 *
 *  For the full copyright and license information, please read the
 *  LICENSE.txt file that was distributed with this source code.
 *
 *  The flex one, in a flex world
 *
 */



module Iroom {
    declare let $: any;

    /**
     * Class Smooth
     *
     * smooth scrolling
     */
    export class ScrollToTop {
        private options                     : ScrollToTopOptions;
        private delay                       : number;
        private link                        : HTMLElement = null;


        /**
         * Loader constructor
         */
        constructor(options : ScrollToTopOptions = null) {
            this.options                    = options;
            this.link                       = document.getElementById("scrollToTop");
            this.init();
        }


        /**
         * init events
         */
        init() {
            this.scrollEvent();
        }


        /**
         * Event when users navigate to an anchor
         */
        scrollEvent() {
            window.addEventListener('scroll', (e) => {
                let scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
                if(scrollTop > 500) {
                    this.link.classList.remove("hidden");
                } else {
                    this.link.classList.add("hidden");
                }
            });

            this.link.addEventListener('click', (e) => {
                e.preventDefault();
                this.setDelay(this.link);
                this.scrollTo(0, this.delay);
            });
        }


        setDelay(link) {
            this.delay                      = 1000;
            if (this.options !== null && this.options.duration > 0) {
                this.delay                  = this.options.duration;
            }
            if (link !== null && parseInt(this.getAttr(link, "data-duration")) > 0) {
                this.delay                  = parseInt(this.getAttr(link, "data-duration"));
            }
        }


        scrollTo(to, duration) {
            let start                       = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0,
                change                      = to - start,
                increment                   = 20;

            let animateScroll = (elapsedTime) => {
                elapsedTime += increment;
                let position                = easeInOut(elapsedTime, start, change, duration);
                document.documentElement.scrollTop = position;
                document.body.scrollTop     = position;
                if (elapsedTime < duration) {
                    setTimeout(() => {
                        animateScroll(elapsedTime);
                    }, increment);
                }
            };

            let easeInOut = (currentTime, start, change, duration) =>{
                currentTime /= duration / 2;
                if (currentTime < 1) {
                    return change / 2 * currentTime * currentTime + start;
                }
                currentTime -= 1;
                return -change / 2 * (currentTime * (currentTime - 2) - 1) + start;
            }

            animateScroll(0);
        }


        /**
         * Function to hack the IE BUG
         *
         * Undefiend function eobject.getAttribute()
         *
         * @param ele
         * @param attr
         * @returns {(function(string=): string)|string|null}
         */
        getAttr(ele, attr) {
            let result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if( !result ) {
                var attrs = ele.attributes;
                if(attrs != null) {
                    var length = attrs.length;
                    for(var i = 0; i < length; i++) {
                        if(attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        }
    }

    /**
     * interface ScrollToTop Options
     */
    interface ScrollToTopOptions {
        duration : number;
    }
}